/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Collections3 {
    private Collections3() {
    }

    public static <E> E search(Collection<E> collection, Predicate<? super E> predicate) {
        for (E element : collection) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return null;
    }

    @SafeVarargs
    public static <E> Set<E> unmodifiableSet(E ... items) {
        return Collections.unmodifiableSet(Sets.newHashSet(items));
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @Nonnull
    public static <E> List<E> joinLists(List<? extends E> ... lists) {
        void var5_8;
        int size = 0;
        for (List<E> list : lists) {
            if (list == null) continue;
            size += list.size();
        }
        ArrayList<? extends E> joinedList = Lists.newArrayListWithCapacity(size);
        List<? extends E>[] listArray = lists;
        int n = listArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            List<? extends E> list = listArray[var5_8];
            if (list != null) {
                joinedList.addAll(list);
            }
            ++var5_8;
        }
        return joinedList;
    }

    public static <E> boolean containsObject(Collection<E> collection, E obj) {
        boolean res = false;
        for (E elem : collection) {
            if (elem != obj) continue;
            res = true;
            break;
        }
        return res;
    }

    public static <F> double sumDouble(@Nonnull Collection<F> values, @Nonnull Function<F, Double> function) {
        Double res = 0.0;
        for (F value : values) {
            res = res + function.apply(value);
        }
        return res;
    }

    public static <E> List<E> takeWhile(@Nonnull Collection<E> collection, @Nonnull Predicate<E> predicate) {
        ArrayList<E> res = Lists.newArrayList();
        for (E e : collection) {
            if (!predicate.apply(e)) continue;
            res.add(e);
        }
        return res;
    }

    public static <E1, E2> List<Tuple<E1, E2>> zip(@Nonnull List<E1> a, @Nonnull List<E2> b) {
        Iterator<E1> aIt = a.iterator();
        Iterator<E2> bIt = b.iterator();
        ArrayList<Tuple<E1, E2>> res = Lists.newArrayListWithCapacity(Math.min(a.size(), b.size()));
        while (aIt.hasNext() && bIt.hasNext()) {
            res.add(Tuple.create(aIt.next(), bIt.next()));
        }
        return res;
    }

    public static <E> List<E> groupWith(@Nonnull List<E> l, Predicate<Tuple<E, E>> groupPredicate, Function<Tuple<E, E>, E> combinator, boolean inplace) {
        Preconditions.checkNotNull(l);
        if (l.isEmpty()) {
            return inplace ? l : Collections.emptyList();
        }
        if (!inplace) {
            l = Lists.newLinkedList(l);
        }
        ListIterator<E> li = l.listIterator();
        E last = li.next();
        while (li.hasNext()) {
            E next = li.next();
            Tuple<E, E> pair = Tuple.create(last, next);
            if (!groupPredicate.apply(pair)) {
                last = next;
                continue;
            }
            E result = combinator.apply(pair);
            li.previous();
            li.remove();
            li.previous();
            li.set(result);
            li.next();
        }
        return l;
    }

    public static <T> List<T> safeCast(@Nullable List<?> list, @Nonnull Class<T> elementType) {
        Preconditions.checkNotNull(elementType);
        if (list == null) {
            return null;
        }
        for (Object el : list) {
            if (elementType.isAssignableFrom(el.getClass())) continue;
            throw new ClassCastException("List contains element of type " + el.getClass().getName());
        }
        return list;
    }

    public static <K, V> Map<K, V> safeCast(@Nullable Map<?, ?> map, @Nonnull Class<K> keyType, @Nonnull Class<V> valType) {
        if (map == null) {
            return null;
        }
        Preconditions.checkNotNull(keyType);
        Preconditions.checkNotNull(valType);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (!keyType.isAssignableFrom(e.getKey().getClass())) {
                throw new ClassCastException("Map contains key of type " + e.getKey().getClass().getName());
            }
            if (valType.isAssignableFrom(e.getValue().getClass())) continue;
            throw new ClassCastException("Map contains value of type " + e.getValue().getClass().getName());
        }
        return map;
    }

    public static <T extends Comparable<? super T>> List<T> sorted(Iterable<T> input) {
        ArrayList<T> output = Lists.newArrayList(input);
        Collections.sort(output);
        return output;
    }

    public static <T> List<T> sorted(Iterable<T> input, Comparator<T> comparator) {
        ArrayList<T> output = Lists.newArrayList(input);
        output.sort(comparator);
        return output;
    }

    public static <T> Collection<T> nullToEmpty(Collection<T> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return input;
    }

    public static <T> Set<T> nullToEmpty(Set<T> input) {
        if (input == null) {
            return Collections.emptySet();
        }
        return input;
    }

    public static <T> List<T> nullToEmpty(List<T> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return input;
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<K, V> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        return input;
    }

    public static <T> Iterator<T> nullToEmpty(Iterator<T> input) {
        if (input == null) {
            return Collections.emptyIterator();
        }
        return input;
    }
}

